(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3787,         99]*)
(*NotebookOutlinePosition[      4491,        123]*)
(*  CellTagsIndexPosition[      4447,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(f[x_] = x - 0.6  Sin[x]\)], "Input"],

Cell[BoxData[
    \(A = 
      Plot[f[x], {x, 0, 10}, \ 
        AspectRatio \[Rule] Automatic\[IndentingNewLine], 
        AxesStyle \[Rule] {Thickness[0.003]}, 
        PlotStyle \[Rule] {Thickness[0.0035]}, AxesOrigin \[Rule] {0, 0}, 
        Ticks \[Rule] None]\)], "Input"],

Cell[BoxData[
    RowBox[{"B", "=", 
      RowBox[{"{", 
        RowBox[{\(Line[{{2, 0}, {2, f[2]}, {0, f[2]}}]\), 
          ",", \(Line[{{0, 0}, {10, 10 \( f'\)[0]}}]\), 
          ",", \(Line[{{0, 0}, {2, f[2]}, {9, 4.5  f[2]}}]\), 
          ",", \(Line[{{0, f[2] - 2 \( f'\)[2]}, {8, f[2] + \(f'\)[2] 6}}]\), 
          ",", \(Line[{{4, 0}, {4, f[4]}, {0, f[4]}}]\), 
          ",", \(Line[{{5, 0}, {5, f[5]}, {0, f[5]}}]\), 
          ",", \(Text[\*"\"\<g(\!\(x\_0\))\>\"", {1.8, \(-0.5\)}]\), 
          ",", \(Text[\*"\"\<f(\!\(x\_0\))\>\"", {\(-1\), f[2]}]\), 
          ",", \(Text[\*"\"\<\!\(\(f \((x\_0)\)\)\/\(g \((x\_0)\)\)\)\
\[TildeEqual]\!\(\(f' \((x\_0)\)\)\/\(g' \((x\_0)\)\)\)\[TildeEqual]L\>\"", \
{3, \(-1.7\)}]\), ",", \(Text["\<g(x)\>", {4.8, \(-0.5\)}]\), 
          ",", \(Text["\<f(x)\>", {\(-0.9\), f[5]}]\), ",", 
          RowBox[{"Text", "[", 
            RowBox[{
            "\"\<\!\(\*Cell[\"\[CapitalGamma]\"]\)\>\"", 
              ",", \({7, f[7] - 0.5}\)}], "]"}], 
          ",", \(Text[\*"\"\<y=\!\(\(f \((x\_0)\)\)\/\(g \
\((x\_0)\)\)\)x\>\"", {7, 3  f[2] - 0.4}]\), 
          ",", \(Text["\<y=Lx\>", {7, 7 \( f'\)[0] - 0.4}]\), 
          ",", \(Text[\*"\"\<y=f(\!\(x\_0\))+\!\(\(f' \((x\_0)\)\)\/\(g' \((x\
\_0)\)\)\)(x-g(\!\(x\_0\)))\>\"", {3.5, f[2] + 5 \( f'\)[2] + 0.4}]\)}], 
        "}"}]}]], "Input"],

Cell[BoxData[
    \(TextStyle \[Rule] {FontFamily -> "\<Times\>", \ 
        FontSize \[Rule] 12}\)], "Input"],

Cell[BoxData[
    \(Show[A, Graphics[B], PlotRange \[Rule] All, 
      TextStyle \[Rule] {FontSlant -> "\<Italic\>", 
          FontFamily -> "\<Times\>", \ FontSize \[Rule] 13}]\)], "Input"],

Cell[BoxData[
    \(Display["\<Hopital_new.eps\>", %, "\<EPS\>"]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 56, 1, 30, "Input"],
Cell[1764, 53, 278, 6, 50, "Input"],
Cell[2045, 61, 1351, 24, 178, "Input"],
Cell[3399, 87, 110, 2, 30, "Input"],
Cell[3512, 91, 191, 3, 50, "Input"],
Cell[3706, 96, 77, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

